﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Runtime.InteropServices

' 此类封装函数 Beep 的调用变体。
Public Class CallingVariations

    ' Declare 版本
    Public Declare Function DeclareBeep Lib "kernel32" Alias "Beep" _
        (ByVal dwFreq As Integer, ByVal dwDuration As Integer) As Integer

    ' DLLImport 版本
    <DllImport("kernel32.dll", EntryPoint:="Beep")> _
    Public Shared Function DLLImportBeep(ByVal dwFreq As Integer, _
        ByVal dwDuration As Integer) As Integer
    End Function

    ' 指定 Unicode
    Public Declare Unicode Function UnicodeBeep Lib "kernel32" Alias "Beep" _
        (ByVal dwFreq As Integer, ByVal dwDuration As Integer) As Integer

    ' 指定 Ansi
    Public Declare Ansi Function ANSIBeep Lib "kernel32" Alias "Beep" _
        (ByVal dwFreq As Integer, ByVal dwDuration As Integer) As Integer

    ' 指定 Auto
    Public Declare Auto Function AutoBeep Lib "kernel32" Alias "Beep" _
        (ByVal dwFreq As Integer, ByVal dwDuration As Integer) As Integer

    ' 使用精确拼写
    ' ExactSpelling 的默认值为 False。
    ' 如果为 False，则会在 ANSI 下追加 A，在 Unicode 下追加 W，以使 Beep 成为 BeepW。
    <DllImport("kernel32.dll", ExactSpelling:=True, CharSet:=CharSet.Ansi, EntryPoint:="BeepW")> _
    Public Shared Function ExactSpellingBeep(ByVal dwFreq As Integer, _
        ByVal dwDuration As Integer) As Integer
    End Function

End Class

